;;########################################################################
;; mmrvis2.lsp
;; help for visualization for multivariate multiple regression
;; new visualization written by Forrest W. Young Oct-Dec 1997
;; Copyright (c) 1999 by Forrest W. Young
;;########################################################################
  

(defmeth mmr-model-object-proto :visualization-help 
  (sp spin-plot influence-plot reg-plot resid-plot redun-rays)


  (defmeth sp :spreadplot-help ()
    (plot-help-window (strcat "SpreadPlot Help"))
    (paste-plot-help (format nil "This is the SpreadPlot for Multivariate Multiple Regression Analysis. In this SpreadPlot the windows are linked by the data's observations and variables.~2%"))
    (paste-plot-help (format nil "The Scatterplot Matrix window, which is in the upper left corner, lets you choose which Predictor Variables are displayed in other windows. You can select a single Predictor Variable by clicking on a diagonal cell in this matrix, or you can select two Predictor Variables by clicking on an off-diagonal cell. You can also select several Predictor Variables by shift-clicking on several cells.~2%"))
(paste-plot-help (format nil "The Point and Vector Labels window, at the lower left, presents labels for Observations (points) and Response Variables. Selecting Observation labels will cause points in the other plots to be highlighted. Selecting Response Variable labels will cause vectors to be highlighted, and will change several of the plots to show information about the Response Variable.~2%"))
(paste-plot-help (format nil
"The points in the windows of this spreadplot are linked together. When you brush or click on them in one window, the corresponding points in other windows are also highlighted. The points are linked together because they represent the same observations in your data.~2%"))
    (show-plot-help)
    (call-next-method :skip t :flush nil))

  (defmeth spin-plot :plot-help ()
    (plot-help-window (strcat "Help for " (send self :title)))
    (paste-plot-help (format nil "The help for the spinning biplot is divided into two sections. The first section is specific help for the biplot as used in multivariate regression. The second section is general help about using spinning plots.~2%HELP FOR MULTIVARIATE REGRESSION SPINNING BIPLOT~2%"))
    (paste-plot-help (format nil "A Spinning Biplot is an enhanced spinning 3-dimensional scatterplot that uses both points and vectors to represent structure. As used in Multivariate Regression Analysis, the axes of a biplot are predictor variables, the points represent observations, and the vectors represent response variables. In particular, the blue observation points are located according to the scores of the observations on the predictor variables, and the green response variable vectors are located to represent the coefficients of the predictor variables for the response.~2%"))
    (paste-plot-help (format nil "The relative location of the points can be interpreted. Points that are close together correspond to observations that have similar scores on the predictor variables displayed in the plot. To the extent that these predictors fit the response variables well, the points also correspond to observations that have similar values on the response variables.~2%"))
    (paste-plot-help (format nil "Both the direction and length of the vectors can be interpreted. Vectors point away from the origin in some direction. Vectors that point in the same direction correspond to variables that have similar relationships to the predictors, and can be interpreted as having similar meaning in the context set by the data. Long vectors are more strongly related to the predictors being displayed than are short vectors. Long vectors are more important in interpreting the meaning of the predictors that they are long on.~2%"))
(when redun-rays
      (paste-plot-help (format nil "Finally, the red vectors represent the redundancy variables, which are the redundancy analysis model of your data. The first redundancy variable is labeled RED0. It is the linear combination of the predictor variables which has the highest average squared correlation with all of the response variables. It as the direction in the predictor variable space that maximizes maximize the variance accounted for in the response variables. The second redundancy variable (RED1) is similar to RED0, but is defined in the residual space that remains after computing RED0.~2%")))
      (paste-plot-help (format nil "HELP FOR SPINNING PLOTS~2%"))
  (show-plot-help)
  (call-next-method :flush nil))

  (defmeth influence-plot :plot-help ()
    (plot-help-window (strcat "Help for " (send self :title)))
    (paste-plot-help (format nil 
"The influence plot is a regression diagnostic plot: It helps diagonse the stabililty of the regression analysis for the data being analyzed. Influence plots may be used to determine the influence of a particular observation on the regression parameter estimates. In particular, the plot shows the effect, on the values of one of the response variables, of removing an individual observation.~2%"))
    (paste-plot-help (format nil
"You can control which response variable is shown in this plot by clicking on a response variable's name in the POINT AND VECTOR LABELS window. The response variable names appear at the end of the list of labels.~2%"))
    (paste-plot-help (format nil 
"The influence plot uses Cook's distance measure. This measure determines the influence of removing an observation by estimating the difference between the regression coefficients calculated when the observation is included in the analysis and when it is omitted from the analysis.~2%"))
    (paste-plot-help (format nil 
"A large Cook's distance suggests that the observation has a large influence on the calculation of the parameter estimates: Small changes in the observation will have relatively large effects on the parameter estimates. If such an observation is not reliable, then the model is also not reliable and we do not have stable estimates of the parameters.~2%"))
    (show-plot-help)
    )

    (defmeth reg-plot :plot-help ()
      (plot-help-window (strcat "Help for " (send self :title)))
      (paste-plot-help (format nil 
"The Fit plot is a plot, for one of the response variables, of the predicted values of the response variable versus the observed value of the response variable.~2%"))
(paste-plot-help (format nil
"You can control which response variable is shown in this plot by clicking on a response variable's name in the POINT AND VECTOR LABELS window. The response variable names appear at the end of the list of labels.~2%"))
(paste-plot-help (format nil
"The line through the plot represents perfect fit. To the extent that the points deviate from this line the predicted values are not fitting the actual observed response variable well. The greater the deviation, the worse the fit.~2%"))
      (show-plot-help)
      )

    (defmeth resid-plot :plot-help ()
      (plot-help-window (strcat "Help for " (send self :title)))
      (paste-plot-help (format nil 
"The residuals plot is a plot, for one of the response variables, of the residuals versus the predicted values for the selected response variable.~2%"))
(paste-plot-help (format nil
"You can control which response variable is shown in this plot by clicking on a response variable's name in the POINT AND VECTOR LABELS window. The response variable names appear at the end of the list of labels.~2%"))
      (paste-plot-help (format nil 
"The residuals plot is a regression diagnostic plot: It helps diagonse the suitability of the assumptions underlying regression analysis to the data being analyzed. Residual plots may be used to detect nonnormal error distributions, constant error variance (heteroscedasticity), nonlinearity and outliers.~2%"))
      (paste-plot-help (format nil 
"NORMALITY: The points in the plot should be randomly distributed about the zero line. If they are not, then the assumption of normality has probably not been met.~2%"))
      (paste-plot-help (format nil 
"LINEARITY: Points that form a systematic pattern, such as a curve, suggest that the assumption of linearity has been violated.~2%"))
      (paste-plot-help  (format nil "HETEROSCADASTICITY: The variance of the residuals should be about the same for all values of the predicted response variable. If the variance changes systematically with the response variable, then the assumption of constant error variance has not been met.~2%"))
      (paste-plot-help  (format nil "OUTLIERS: Outliers may be identified by examining observations which have residuals that are much larger than the rest of the residual values.~2%"))
  (show-plot-help)
  )

  )
